//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: example of flash memory operation
// 		 		  make sure that the chip does not power off or reset before the FLASH function is completely
//****************************************** 
//******************************************
//Stack Pointer	=	0x23f (If use mq6821_x_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6821.h"


//==============================================================================
// 	variable
//==============================================================================
unsigned char ReadData,ReadBuf[10],ret[10];
void main()
{
//==============================================================================
//	Flash_SectionErase(address)
//  address	:0x7e80~0x7eff,0xc000~0xffff
//  retval  :0:erase success  1:erase fail 3:invalid address parameter
//  the flash memory area to be erased is specified by address
// 
//  note 	: when erase, IMF=0 will be set temporarily, CPU will not accept "maskable interrupt" signal for the time being
//   
//==============================================================================	
	ret[0]=Flash_SectionErase(0x7e80);//erase 0x7e80~0x7eff
	ret[1]=Flash_SectionErase(0xff00);//erase 0xff00 ~0xff7f	
	ret[2]=Flash_SectionErase(0xfe02);//erase 0xfe00 ~0xfe7f	

//==============================================================================
//	Flash_WriteByte(address,data)
//  address	:0x7e80~0x7eff,0xc000~0xffff
//  data	:0x00~0xff
//  retval  : 0:write success  1:write fail<difference from expected value after writing>  2:write fail<not 0xFF before writing>
//            3:invalid address parameter
//  note 	: when erase, IMF=0 will be set temporarily, CPU will not accept "maskable interrupt" signal for the time being
//==============================================================================	
	ret[3]=Flash_WriteByte(0x7e80,0x55);
	ret[4]=Flash_WriteByte(0xff00,0xaa);
	ret[5]=Flash_WriteByte(0xfe01,0x51);
	ret[6]=Flash_WriteByte(0xfe02,0x52);
	ret[7]=Flash_WriteByte(0xfe03,0x53);
	
//==============================================================================
//	Flash_ReadByte(address)
//  address	:0x7e80~0x7eff,0xc000~0xffff
//  retval  :0x00~0xff
//==============================================================================		
	ReadData = Flash_ReadByte(0x7e80);
	ReadData = Flash_ReadByte(0xff00);
	ReadData = Flash_ReadByte(0xfe01);	
			
//==============================================================================
//	Flash_ReadSequence(address,data array,data length)
//  address	:0x7e80~0x7eff,0xc000~0xffff
//  data array	:array of unsigned char type
//  data length	:read byte counts
// 
//  note: the watchdog will be cleared in the function, if the watchdog has special settings (limited to clear the first 1/4, 1/2, 3/4 overflow time), it may generate a watchdog interrupt
//==============================================================================			
	Flash_ReadSequence(0xfe01,ReadBuf,3);
	
	
//---dummy loop---//
	while(1)
	{
		WDCDR.byte=0x4e; 		//clear wdt
	}
	
}